IF EXISTS (
		SELECT *
		FROM SYS.INDEXES
		WHERE NAME = 'IX_EST_NF_ENT_AGRUPAMENTO_NFE'
		)
BEGIN
	DROP INDEX [IX_EST_NF_ENT_AGRUPAMENTO_NFE] ON [dbo].[EST_NF_ENT]
END
GO

IF NOT EXISTS (
		SELECT *
		FROM SYS.INDEXES
		WHERE NAME = 'IX_EST_NF_ENT_AGRUPAMENTO_NFE'
		)
BEGIN
	CREATE NONCLUSTERED INDEX [IX_EST_NF_ENT_AGRUPAMENTO_NFE] ON [dbo].[EST_NF_ENT] (
	[CD_EMP]
	,[CD_FILIAL]
	,[CD_FORN]
	,[FLAG_NOTA_INTEGRACAO]
	,[DT_ENT]
	) INCLUDE (
	[DT_EMI_NF]
	,[NR_NF]
	,[VLR_NF]
	,[CD_NT_MOV]
	,[IGNORAR_GERACAO_FINAN]
	)
	WITH (
			PAD_INDEX = OFF
			,STATISTICS_NORECOMPUTE = ON
			,SORT_IN_TEMPDB = OFF
			,DROP_EXISTING = OFF
			,ONLINE = OFF
			,ALLOW_ROW_LOCKS = ON
			,ALLOW_PAGE_LOCKS = ON
			,FILLFACTOR = 97
			) ON [PRIMARY]
END
GO


